{ $HDR$}
{**********************************************************************}
{ Unit archived using Team Coherence                                   }
{ Team Coherence is Copyright 2002 by Quality Software Components      }
{                                                                      }
{ For further information / comments, visit our WEB site at            }
{ http://www.TeamCoherence.com                                         }
{**********************************************************************}
{}
{ $Log:  13752: IdCoder.pas
{
{   Rev 1.6    11/10/2003 7:39:22 PM  BGooijen
{ Did all todo's ( TStream to TIdStream mainly )
}
{
{   Rev 1.5    2003.10.02 10:52:48 PM  czhower
{ .Net
}
{
{   Rev 1.4    2003.06.24 12:02:08 AM  czhower
{ Coders now decode properly again.
}
{
{   Rev 1.3    2003.06.13 6:57:08 PM  czhower
{ Speed improvement
}
{
{   Rev 1.2    2003.06.13 3:41:18 PM  czhower
{ Optimizaitions.
}
{
{   Rev 1.1    2003.06.13 2:24:06 PM  czhower
{ Speed improvement
}
{
{   Rev 1.0    11/14/2002 02:14:30 PM  JPMugaas
}
unit IdCoder;

interface

uses
  Classes,
  IdBaseComponent,
  IdStream;

type
  TIdEncoder = class(TIdBaseComponent)
  public
    function Encode(const ASrc: string): string; overload;
    function Encode(ASrcStream: TStream; const ABytes: Integer = MaxInt)
     : string; overload; virtual; abstract;
    class function EncodeString(const AIn: string): string;
  end;

  TIdDecoder = class(TIdBaseComponent)
  protected
    FDestIdStream: TIdStream;
  public
    procedure Decode(const AIn: string; const AStartPos: Integer = 1;
     const ABytes: Integer = -1); virtual; abstract;
    procedure DecodeBegin(ADestStream: TStream); virtual;
    procedure DecodeEnd; virtual;
    class function DecodeString(AIn: string): string;
  end;
  TIdDecoderClass = class of TIdDecoder;

implementation

uses
  IdCoreGlobal,
  IdGlobal,
  SysUtils;

{ TIdDecoder }

procedure TIdDecoder.DecodeBegin(ADestStream: TStream);
begin
  FDestIdStream := TIdStream.Create(ADestStream, False);
end;

procedure TIdDecoder.DecodeEnd;
begin
  FreeAndNil(FDestIdStream);
end;

class function TIdDecoder.DecodeString(AIn: string): string;
var
  LDestStream: TStringStream;
begin
  with Create(nil) do try
    LDestStream := TStringStream.Create(''); try  {Do not Localize}
      DecodeBegin(LDestStream); try
        Decode(AIn);
        Result := LDestStream.DataString;
      finally DecodeEnd; end;
    finally FreeAndNil(LDestStream); end;
  finally Free; end;
end;

{ TIdEncoder }

function TIdEncoder.Encode(const ASrc: string): string;
var
  LSrcStream: TStringStream;
begin
  LSrcStream := TStringStream.Create(ASrc); try
    Result := Encode(LSrcStream);
  finally FreeAndNil(LSrcStream); end;
end;

class function TIdEncoder.EncodeString(const AIn: string): string;
begin
  with Create(nil) do try
    Result := Encode(AIn);
  finally Free; end;
end;

end.


